﻿var respondentFiles = {
    context: $(".v-respondentFiles"),
    datatable: null,
    respondentId: $("#RespondentId", this.context).val(),
    initialize: function () {
        var displayRowColumn = $("#DisplayRowColumn", this.context).val() == "True";

        var columns = [];

        columns.push({ "Name": "Position", "Title": "#", "Data": "Position", "Type": "numeric" });
        columns.push({ "Name": "RespondentId", "Title": resources.CaseId, "Data": "RespondentId", "Type": "numeric" });
        columns.push({ "Name": "Block", "Title": resources.Block, "Data": "Block" });
        columns.push({ "Name": "Variable", "Title": resources.Variable, "Data": "Variable" });

        if (displayRowColumn) {
            columns.push({ "Name": "Matrix", "Title": resources.Row, "Data": "Matrix" });
        }

        columns.push({ "Name": "Content", "Title": resources.FileName, "Data": "FileName" });
        columns.push({ "Name": "FileSize", "Title": resources.FileSize, "Data": "FileSize", "Type": "numeric", "Sortable": false });

        this.datatable = $(".h-respondentFilesTable", this.context).a4datatable({
            title: resources.SurveyHistory,
            ajaxAction: a4.getSurveyAction("GetRespondentFiles", "Analyze"),
            ajaxParams: { "respondentId": respondentFiles.respondentId },
            columns: columns,
            contextMenuItems: [
                { "Action": "download", "Label": resources.Download },
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                switch (action) {
                    case "download":
                        window.location = a4.getSurveyAction("DownloadRespondentFile", "Analyze", { variableName: row.Variable, matrix: row.Matrix, respondentId: row.RespondentId });
                        break;
                    case "delete":
                        modalDialog.showConfirmDialog(confirmDeleteFileResources, function () {
                            a4.callServerMethod(a4.getSurveyAction("ClearResponse", "Analyze"), { respondentId: row.RespondentId, variableName: row.Variable, matrix: row.Matrix }, function (result) {
                                respondentFiles.refreshContent();
                            });
                        }, 220, 500, false, {});
                        break;
                }
            },
            toolBarItems: [
                { "Action": "downloadall", "Label": resources.DownloadAll, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "deleteall", "Label": resources.DeleteAll, "DisplayMode": dataTables.itemDisplayMode.nonSelected }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                switch (action) {
                    case "downloadall":
                        window.location = a4.getSurveyAction("DownloadRespondentFiles", "Analyze", { respondentId: respondentFiles.respondentId });
                        break;
                    case "deleteall":
                        modalDialog.showConfirmDialog(confirmDeleteAllFilesResources, function () {
                            a4.callServerMethod(a4.getSurveyAction("ClearFileUploadResponses", "Analyze"), { respondentId: respondentFiles.respondentId }, function (result) {
                                respondentFiles.refreshContent();
                            });
                        }, 220, 500, false, {});
                        break;
                };
            }
        });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    mapSelectedRows: function (rows) {
        return _.map(rows, function (row) {
            var item = {};
            item.RespondentId = row.RespondentId;
            item.Variable = row.Variable;
            item.Matrix = row.Matrix;
            return item;
        });
    }
}

$(document).ready(function () {
    if (respondentFiles.context.length > 0) {
        respondentFiles.initialize();
    }
});